package zwr;

import javax.swing.table.AbstractTableModel;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class StudentTableModel extends AbstractTableModel {

    private List<Student> students;
    private final String[] columnNames = {"学号", "姓名", "性别", "年级", "班级", "出生年月"};

    public StudentTableModel() {
        this.students = new ArrayList<>();
    }

    public void setStudents(List<Student> students) {
        this.students = students;
        fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return students.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Student student = students.get(rowIndex);
        switch (columnIndex) {
            case 0:
                return student.getStudentId();
            case 1:
                return student.getName();
            case 2:
                return student.getGender();
            case 3:
                return student.getGrade();
            case 4:
                return student.getClassName();
            case 5:
                return student.getBirthDate().format(DateTimeFormatter.ofPattern("yyyy年MM月dd日"));
            default:
                return null;
        }
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }
}
