package zwr;

import javax.swing.*;
import java.awt.*;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;


public class StudentManagementGUI {
    private JFrame frame;
    private JTable studentTable;
    private StudentTableModel tableModel;

    public StudentManagementGUI() {
        frame = new JFrame("小学学生信息管理系统");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(800, 600);

        tableModel = new StudentTableModel();
        studentTable = new JTable(tableModel);

        JScrollPane scrollPane = new JScrollPane(studentTable);
        frame.add(scrollPane, BorderLayout.CENTER);

        JButton addButton = new JButton("新增");
        addButton.addActionListener(e -> showAddStudentDialog());
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(addButton);
        frame.add(buttonPanel, BorderLayout.SOUTH);

        loadStudents();

        frame.setVisible(true);
    }

    // 显示新增学生对话框
    private void showAddStudentDialog() {
        JTextField studentIdField = new JTextField(10);
        JTextField nameField = new JTextField(10);
        JRadioButton maleButton = new JRadioButton("男");
        JRadioButton femaleButton = new JRadioButton("女");
        ButtonGroup genderGroup = new ButtonGroup();
        genderGroup.add(maleButton);
        genderGroup.add(femaleButton);
        JComboBox<String> gradeComboBox = new JComboBox<>(new String[]{"一年级", "二年级", "三年级", "四年级", "五年级", "六年级"});
        JComboBox<String> classComboBox = new JComboBox<>(new String[]{"一班", "二班", "三班"});
        JTextField birthDateField = new JTextField(10);

        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(6, 2));
        panel.add(new JLabel("学号:"));
        panel.add(studentIdField);
        panel.add(new JLabel("姓名:"));
        panel.add(nameField);
        panel.add(new JLabel("性别:"));
        JPanel genderPanel = new JPanel();
        genderPanel.add(maleButton);
        genderPanel.add(femaleButton);
        panel.add(genderPanel);
        panel.add(new JLabel("年级:"));
        panel.add(gradeComboBox);
        panel.add(new JLabel("班级:"));
        panel.add(classComboBox);
        panel.add(new JLabel("出生年月:"));
        panel.add(birthDateField);

        int result = JOptionPane.showConfirmDialog(frame, panel, "新增学生信息", JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
        if (result == JOptionPane.OK_OPTION) {
            String studentId = studentIdField.getText().trim();
            String name = nameField.getText().trim();
            String gender = maleButton.isSelected() ? "男" : "女";
            String grade = (String) gradeComboBox.getSelectedItem();
            String className = (String) classComboBox.getSelectedItem();
            String birthDateString = birthDateField.getText().trim();

            try {
                LocalDate birthDate = LocalDate.parse(birthDateString, DateTimeFormatter.ofPattern("yyyy年MM月dd日"));
                Student student = new Student(studentId, name, gender, grade, className, birthDate);
                boolean success = Database.addStudent(student);
                if (success) {
                    loadStudents();
                } else {
                    JOptionPane.showMessageDialog(frame, "学号已存在或添加失败！");
                }
            } catch (Exception e) {
                JOptionPane.showMessageDialog(frame, "输入格式有误，请检查！");
            }
        }
    }

    // 加载学生信息
    private void loadStudents() {
        List<Student> students = Database.getAllStudents();
        tableModel.setStudents(students);
    }

    public static void main(String[] args) {
        new StudentManagementGUI();
    }
}
